#include "prewx.h"
#include "hovedvindu.h"
/*  TODO - LIST!!

- Mulighet for  fjerne levler

*/

int IKON_STORRELSE = 32;
BEGIN_EVENT_TABLE(Hovedvindu, wxFrame)
		EVT_MENU(uID_Ny_Samling, Hovedvindu::ID_Ny_Samling)
		EVT_MENU(uID_Ny_Level, Hovedvindu::ID_Ny_Level)
		EVT_MENU(uID_Lagre, Hovedvindu::ID_Lagre)
		EVT_MENU(uID_Hent, Hovedvindu::ID_Hent)
		EVT_MENU(uID_Avslutt, Hovedvindu::ID_Avslutt)
		EVT_MENU(uID_Neste, Hovedvindu::ID_Neste)
		EVT_MENU(uID_Forrige, Hovedvindu::ID_Forrige)
		EVT_MENU(uID_Test, Hovedvindu::ID_Test)

		//EVT_MENU(CLIENT_CONNECT,Hovedvindu::OnConnectToServer)
		//EVT_SOCKET(SOCKET_ID,Hovedvindu::OnSocketEvent)
END_EVENT_TABLE()


Hovedvindu::Hovedvindu(const wxString &tittel, const wxPoint &pos, const wxSize &stor)
			:wxFrame((wxFrame *) NULL, -1, tittel, pos, stor)
{
	backBuffer = 0;
	finalBackBuffer = 0;
	arkiv = 0;
	currentFile = "";	
	mus_x = -2;
	mus_y = -2;
	selecta = -1;
	playercount = 0;
	playercountnd = 0;
	posi_x = 0;
	posi_y = 0;
	wxMenuBar *menybar = new wxMenuBar;
	filMeny = new wxMenu;

	filMeny->Append(uID_Ny_Samling, _T("&New archive"));
	filMeny->Append(uID_Ny_Level, _T("N&ew Level"));
	filMeny->AppendSeparator();
	filMeny->Append(uID_Lagre, _T("&Save"));
	filMeny->Append(uID_Hent, _T("&Open"));
	filMeny->AppendSeparator();
	filMeny->Append(uID_Avslutt, _T("&Exit"));
	filMeny->Enable(uID_Ny_Level, false);
	filMeny->Enable(uID_Lagre, false);

	gotoMeny = new wxMenu;

	gotoMeny->Append(uID_Neste, _T("&Next)"));
	gotoMeny->Append(uID_Forrige, _T("&Previous "));
	gotoMeny->Append(uID_Test, _T("&Test Level"));
	//gotoMeny->Append(CLIENT_CONNECT, _T("&Flytt hoyre  (F10)"));
	gotoMeny->Enable(uID_Neste, false);
	gotoMeny->Enable(uID_Forrige, false);
	gotoMeny->Enable(uID_Test, false);

	menybar->Append(filMeny, _T(" &File"));
	menybar->Append(gotoMeny, _T(" &Edit"));

	SetMenuBar(menybar);

	//editorVindu = new wxWindow(this, -1);
	

	CreateStatusBar(4);

	/*SetStatusText(_T(" Hei,"),0);
	SetStatusText(_T(" dette"),1);
	SetStatusText(_T(" er en"),2);
	SetStatusText(_T(" Test! :-)"),3);*/

	// wxToolBar sttter visst bare 16x16 ? ...
	/*
	wxToolBar *toolbar_nice = new wxToolBar(editorVindu,-1,wxDefaultPosition,wxSize(500,500),wxTB_FLAT | wxTB_VERTICAL,_T("Toolbar"));
	wxToolBar *toolbar = new wxToolBar(toolbar_nice,-1,wxDefaultPosition,wxSize(500,500),wxTB_FLAT | wxTB_VERTICAL,_T("Toolbar"));
	// Uten mulighet til  justere strrelsen.
	//wxToolBar *toolbar = CreateToolBar(wxTB_FLAT | wxTB_VERTICAL);

	wxImage Image_vegg = wxBITMAP(IMG_VEGG).ConvertToImage().Scale(32,32);
	Image_vegg.SetMaskColour(255,255,255);
	wxBitmap Bitmap_vegg = wxBitmap(Image_vegg);
	
	wxImage Image_visk = wxBITMAP(IMG_VISK).ConvertToImage().Scale(32,32);
	Image_visk.SetMaskColour(255,255,255);
	wxBitmap Bitmap_visk = wxBitmap(Image_visk);
	
	wxImage Image_fiende = wxBITMAP(IMG_FIENDE).ConvertToImage().Scale(32,32);
	Image_fiende.SetMaskColour(255,255,255);
	wxBitmap Bitmap_fiende = wxBitmap(Image_fiende);
	
	wxImage Image_spiller = wxBITMAP(IMG_SPILLER).ConvertToImage().Scale(32,32);
	Image_spiller.SetMaskColour(255,255,255);
	wxBitmap Bitmap_spiller = wxBitmap(Image_spiller);

	toolbar->AddRadioTool(TOOL_VEGG, _T("Plasser Vegg"), Bitmap_vegg, wxNullBitmap, _T("Plasser Vegg"));
	toolbar->AddRadioTool(TOOL_FIENDE, _T("Plasser Fiende"), Bitmap_fiende, wxNullBitmap, _T("Plasser Fiende"));
	toolbar->AddRadioTool(TOOL_SPILLER, _T("Plasser Spiller"), Bitmap_spiller, wxNullBitmap, _T("Plasser Spiller"));
	toolbar->AddRadioTool(TOOL_VISK, _T("Visk ut objekter"), Bitmap_visk, wxNullBitmap, _T("Visk ut objekter"));


	toolbar->Realize();
	*/

	pa_hoved = new wxPanel(this, -1);

	pa_bilde = new wxPanel(pa_hoved, -1, wxDefaultPosition, wxSize(200, 200), wxBORDER_STATIC);

	editorVindu = new wxWindow(pa_hoved, -1, wxDefaultPosition, wxSize(200,200), wxBORDER_STATIC);
		
	pa_bilde->Connect(-1, -1, wxEVT_COMMAND_BUTTON_CLICKED,
		(wxObjectEventFunction) &Hovedvindu::OnButton, NULL, this);

	editorVindu->Connect(-1, -1, wxEVT_SIZE,
		(wxObjectEventFunction) &Hovedvindu::OnSize, NULL, this);
	editorVindu->Connect(-1, -1, wxEVT_PAINT,
		(wxObjectEventFunction) &Hovedvindu::OnPaint, NULL, this);
	editorVindu->Connect(-1, -1, wxEVT_MOTION,
		(wxObjectEventFunction) &Hovedvindu::OnMouse, NULL, this);
	editorVindu->Connect(-1, -1, wxEVT_LEFT_DOWN,
		(wxObjectEventFunction) &Hovedvindu::OnMousePush, NULL, this);
	editorVindu->Connect(-1, -1, wxEVT_KEY_DOWN,
		(wxObjectEventFunction) &Hovedvindu::OnKey, NULL, this);
	//editorVindu->Connect(-1, -1, wxEVT_SOCKET,
	//	(wxObjectEventFunction) &Hovedvindu::OnSocketEvent, NULL, this);


	/*	st_spillerliv = new wxStaticText(pa_tekst, -1, _T("Liv igjen:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	st_fiender = new wxStaticText(pa_tekst, -1, _T("Fiender igjen:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	st_level = new wxStaticText(pa_tekst, -1, _T("Level:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
    st_speed = new wxStaticText(pa_tekst, -1, _T("Fart:"), wxDefaultPosition, wxSize(100,20), wxST_NO_AUTORESIZE);
	*/
	wxImage Image_vegg = wxBITMAP(IMG_VEGG).ConvertToImage().Scale(IKON_STORRELSE,IKON_STORRELSE);
	//Image_vegg.Replace(255,255,255,0,0,0);
	Image_vegg.SetMaskColour(255,255,255);
	wxBitmap Bitmap_vegg = wxBitmap(Image_vegg);

	wxImage Image_empty = wxBITMAP(IMG_EMPTY).ConvertToImage().Scale(IKON_STORRELSE,IKON_STORRELSE);
	//Image_vegg.Replace(255,255,255,0,0,0);
	Image_vegg.SetMaskColour(255,255,255);
	wxBitmap Bitmap_empty = wxBitmap(Image_empty);
	
	wxImage Image_visk = wxBITMAP(IMG_VISK).ConvertToImage().Scale(IKON_STORRELSE,IKON_STORRELSE);
	Image_visk.SetMaskColour(255,255,255);
	wxBitmap Bitmap_visk = wxBitmap(Image_visk);
	
	wxImage Image_fiende = wxBITMAP(IMG_FIENDE).ConvertToImage().Scale(IKON_STORRELSE,IKON_STORRELSE);
	Image_fiende.SetMaskColour(255,255,255);
	wxBitmap Bitmap_fiende = wxBitmap(Image_fiende);
	
	wxImage Image_spiller = wxBITMAP(IMG_SPILLER).ConvertToImage().Scale(IKON_STORRELSE,IKON_STORRELSE);
	Image_spiller.SetMaskColour(255,255,255);
	//Image_spiller.Replace(255,255,255,0,0,0);
	wxBitmap Bitmap_spiller = wxBitmap(Image_spiller);
	//Image_spiller.Replace(255,255,255,0,0,0);
	//wxBitmap Bitmap_spillerdo = wxBitmap(Image_spiller);

	//wxImage sec_spiller = wxBitmap(sprites[TOOL_SPILLER]).ConvertToImage();
	//sec_spiller.SetMaskColour(255,255,255);
	Image_spiller.Replace(153,255,0,153,0,255);
	Image_spiller.Replace(0,153,0,0,0,153);
	Image_spiller.Replace(0,72,0,0,0,102);
	wxBitmap Bitmap_spillernd = wxBitmap(Image_spiller);
	//Image_spiller.Replace(255,255,255,0,0,0);
	
	BUT_SPILLER = new wxBitmapButton(pa_bilde,TOOL_SPILLER,Bitmap_spiller,wxDefaultPosition,wxDefaultSize,wxBU_AUTODRAW);
	BUT_FIENDE = new wxBitmapButton(pa_bilde,TOOL_FIENDE,Bitmap_fiende,wxDefaultPosition,wxDefaultSize,wxBU_AUTODRAW);
	BUT_VEGG = new wxBitmapButton(pa_bilde,TOOL_VEGG,Bitmap_vegg,wxDefaultPosition,wxDefaultSize,wxBU_AUTODRAW);
	BUT_VISK = new wxBitmapButton(pa_bilde,TOOL_VISK,Bitmap_visk,wxDefaultPosition,wxDefaultSize,wxBU_AUTODRAW);

	wxBoxSizer *boxsizer = new wxBoxSizer(wxHORIZONTAL );

	boxsizer->Add(pa_bilde, 0, wxGROW|wxALL|wxSTRETCH_NOT,0);
	boxsizer->Add(editorVindu, 1, wxGROW|wxALL,0);
	//boxsizer->Add(pa_tekst, 0, wxGROW|wxALL|wxSTRETCH_NOT,5);

		
	wxBoxSizer *pa_bilde_sizer = new wxBoxSizer(wxVERTICAL);

	pa_bilde_sizer->Add(BUT_SPILLER,0,wxTOP,0);
	pa_bilde_sizer->Add(BUT_FIENDE,0,wxTOP,0);
	pa_bilde_sizer->Add(BUT_VEGG,0,wxTOP,0);
	pa_bilde_sizer->Add(BUT_VISK,0,wxTOP,0);
	//pa_bilde_sizer->Add(test2,0,wxTOP,5);
	//pa_tekst_sizer->Add(st_level,0,wxTOP,5);
	//pa_tekst_sizer->Add(st_speed,0,wxTOP,5);*/

	pa_hoved->SetAutoLayout(TRUE);
	pa_hoved->SetSizer(boxsizer);

	pa_bilde->SetAutoLayout(TRUE);
	pa_bilde->SetSizer(pa_bilde_sizer);

	sprites[TOOL_VISK] = Bitmap_empty;
	sprites[TOOL_VEGG] = Bitmap_vegg;
	sprites[TOOL_SPILLER] = Bitmap_spiller;
	sprites[TOOL_FIENDE] = Bitmap_fiende;
	sprites[4] = Bitmap_spillernd;


	//sprites = {Bitmap_empty, Bitmap_vegg, Bitmap_spiller, Bitmap_fiende};


}

Hovedvindu::~Hovedvindu(void)
{
	// Er det noe som ikke wxWidgets fjerner for deg??
}

void Hovedvindu::ID_Ny_Samling(wxCommandEvent &event)
{
	Nytt_Arkiv();
}

bool Hovedvindu::Nytt_Arkiv(void)
{
	
	if(arkiv != 0)
	{
		wxMessageDialog *alert = new wxMessageDialog(editorVindu,_T("Er du sikker p at du vil lage et nytt arkiv?"), _T("Nytt arkiv"), wxYES_NO | wxICON_QUESTION);
		if(alert->ShowModal() != wxID_YES)
		{
			return false;
		}
	}
	Arkiv *backup = arkiv;
	int back_levelIndex = levelsize;

	arkiv = new Arkiv;
	levelsize = 0;

	if(!NyLevel())
	{
		delete arkiv;
		arkiv = backup;
		levelsize = back_levelIndex;
	}
	else
	{
		delete backup;
			filMeny->Enable(uID_Ny_Level, true);
			filMeny->Enable(uID_Lagre, true);

			gotoMeny->Enable(uID_Neste, false);
			gotoMeny->Enable(uID_Forrige, false);
			gotoMeny->Enable(uID_Test, levelsize != 0);
	}
	return true;
}

void Hovedvindu::ID_Ny_Level(wxCommandEvent &event)
{
	NyLevel();
}

void Hovedvindu::ID_Hent(wxCommandEvent &event)
{
	wxFileDialog hent(this, _T("Hent fil"), _T(""), _T(""), _T("Level (*.sgc)|*.sgc"),0);

	if(hent.ShowModal() == wxID_OK)
	{
		//Lagrefil(hent.GetPath().c_str());
		FILE *hentfil;
		
		const wxChar *filenavn = hent.GetPath().c_str();
		currentFile = hent.GetFilename().c_str();
		//hentfil = 
		fopen_s(&hentfil, filenavn, "r+b");

		int antall; 
		fread(&antall,sizeof(int),1,hentfil);

		if(arkiv)
			delete arkiv;

		arkiv = new Arkiv;
 
		for(int i = 0; i < antall; i++)
		{
			map *MapLevel = new map;

			fread(&MapLevel->x, sizeof(int), 1, hentfil);
			fread(&MapLevel->y, sizeof(int), 1, hentfil);

			MapLevel->level = new char *[MapLevel->x];

			for (int s = 0; s < MapLevel->x; s++)
			{
				MapLevel->level[s] = new char[MapLevel->y];
				fread(MapLevel->level[s], sizeof(char), MapLevel->y, hentfil);
			}

			arkiv->push_back(MapLevel);

			if(i == 0) 
			{
				levelsize = 1;
				SetLevel(MapLevel);
			}
		}
		fclose(hentfil);

		filMeny->Enable(uID_Ny_Level, true);
		filMeny->Enable(uID_Lagre, true);
		gotoMeny->Enable(uID_Neste, levelsize != arkiv->size());
		gotoMeny->Enable(uID_Forrige, levelsize != 1);
		gotoMeny->Enable(uID_Test, true);

		updateDraw();


	}

}

void Hovedvindu::ID_Lagre(wxCommandEvent &event)
{
	wxString defaultfilename;
	if(currentFile == "")
	{
		defaultfilename = _T("Level1.sgc");
	} 
	else 
	{
		defaultfilename = currentFile;
	}
	wxFileDialog save(this, _T("Lagre fil"), _T(""), defaultfilename, _T("Level (*.sgc)|*.sgc"), wxSAVE | wxOVERWRITE_PROMPT);
	
	if(save.ShowModal() == wxID_OK)
	{	
		currentFile = save.GetFilename().c_str();
		wxString topic = _T("Bug-hunter leveleditor - Level ") + wxString::Format(_T("%d"), levelsize) + _T(" [") + wxString::Format(_T("%s"), currentFile) + _T("]");
		SetTitle(topic);
		Lagrefil(save.GetPath().c_str());
	}
}

void Hovedvindu::ID_Avslutt(wxCommandEvent &event)
{
	Close(TRUE);
}

void Hovedvindu::ID_Neste(wxCommandEvent &event)
{
	Do_Neste();
}

void Hovedvindu::ID_Forrige(wxCommandEvent &event)
{
	Do_Forrige();
}

void Hovedvindu::ID_Test(wxCommandEvent &event)
{
	Lagrefil("temp.sgc");
	//wxExecute(wxString::Format("TG_SPILL_DEV.exe temp.sgc %d", (long)levelsize));
	wxString levelerrsor = _T("Bug-hunter.exe temp.sgc ") + wxString::Format(_T("%d"), (long)levelsize);
	//wxMessageBox(levelerrsor,_T("Feil ved laging av ny level!"),wxICON_ERROR);
	//wxString levelerror = _T("TG_SPILL_DEV.exe temp.sgc %d, 5");
	wxExecute(levelerrsor);
}


void Hovedvindu::ID_Plasser_Spiller()
{
	/*if(playercount > 0)
	{
		selecta = -1;
		return;
	}
	playercount++;*/
	/*wxString levelerror = _T("Plasser Spiller");
	wxMessageBox(levelerror,_T("HM."));*/
}

void Hovedvindu::ID_Plasser_Fiende()
{
	/*	wxString levelerror = _T("Plasser Fiende");
	wxMessageBox(levelerror,_T("HM."));*/
}

void Hovedvindu::ID_Plasser_Vegg()
{
	/*	wxString levelerror = _T("Plasser Vegg");
	wxMessageBox(levelerror,_T("HM."));*/
}

void Hovedvindu::ID_Visk()
{
	// Husk  minke playercount.

	/*wxString levelerror = _T("Visk litt");
	wxMessageBox(levelerror,_T("HM."));*/
}


void Hovedvindu::OnButton(wxCommandEvent &event)
{
	selecta = event.GetId();
	//wxString levelerror = _T("Du prvde  lage en level med: ") + wxString::Format(_T("%d"), selecta) + _T("\nDen eksisterer ikke!");
	//wxMessageBox(levelerror,_T("Feil ved laging av ny level!"),wxICON_ERROR);
	switch (event.GetId())
	{
	case TOOL_SPILLER:
		Hovedvindu::ID_Plasser_Spiller();
		break;
	case TOOL_FIENDE:
		Hovedvindu::ID_Plasser_Fiende();
		break;
	case TOOL_VEGG:
		Hovedvindu::ID_Plasser_Vegg();
		break;
	case TOOL_VISK:
		Hovedvindu::ID_Visk();
		break;
	};
}

bool Hovedvindu::NyLevel(void)
{
	int bredde = wxGetNumberFromUser(_T("Level bredde."),_T("Skriv her"),_T("Level setup"),15,0,100,this);
	
	if(bredde < 1)
	{
		return false;
	}

	int hoyde = wxGetNumberFromUser(_T("Level hyde."),_T("Skriv her"),_T("Level setup"),15,0,100,this);

	if(hoyde < 1)
	{
		return false;
	}

	Levelmap = new map;

	arkiv->push_back(Levelmap);

	levelsize = int(arkiv->size());

	Levelmap->x = bredde;
	Levelmap->y = hoyde;

	Levelmap->level = new char *[bredde];
	 
	for (int a = 0; a < bredde; a++)
	{
		Levelmap->level[a] = new char[Levelmap->y];
	}

	for (int b = 0; b < bredde; b++)
	{
		for(int c = 0; c < hoyde; c++)
		{
			Levelmap->level[b][c] = 0;
		}
	}

		gotoMeny->Enable(uID_Neste, levelsize != arkiv->size());
		gotoMeny->Enable(uID_Forrige, levelsize != 1);
		gotoMeny->Enable(uID_Test, true);

	SetLevel(Levelmap);

	return true;

}

void Hovedvindu::SetLevel(map *brett)
{
	Levelmap = brett;
	backBuffer = new wxBitmap(Levelmap->x * (IKON_STORRELSE + 1) + 1, Levelmap->y * (IKON_STORRELSE + 1) + 1);
	wxString topic;
	if(currentFile == "")
	{
		topic = _T("Bug-hunter leveleditor - Level ") + wxString::Format(_T("%d"), levelsize);
	}
	else
	{
		topic = _T("Bug-hunter leveleditor - Level ") + wxString::Format(_T("%d"), levelsize) + _T(" [") + wxString::Format(_T("%s"), currentFile) + _T("]");
	}
	
	SetTitle(topic);

	wxString status_text0 = _T("Strrelse: ") + wxString::Format(_T("%d"), Levelmap->x) + _T("x") + wxString::Format(_T("%d"), Levelmap->y);
	SetStatusText(status_text0,0);

	wxString status_text1 = _T("Level: ") + wxString::Format(_T("%d"), levelsize);
	SetStatusText(status_text1,1);
	playercount = 0;
	playercountnd = 0;
	updateDraw();
}

void Hovedvindu::OnKey(wxKeyEvent &event)
{
	switch(event.GetKeyCode())
	{
	case WXK_F7:
		if(levelsize != 1)
			Do_Forrige();
		break;
	case WXK_F8:
		if(levelsize != arkiv->size())
			Do_Neste();
		break;
	case WXK_F9:
		if(levelsize != 0)
			Do_Test();
		break;
	};
}

void Hovedvindu::Do_Neste(void)
{
	if(levelsize <= (int)arkiv->size())
	{
	levelsize++;
	Arkiv::iterator nask;
	int intnask = 0;
		
		for(nask = arkiv->begin(); nask != arkiv->end(); nask++)
		{
			intnask++;
			if(intnask == levelsize)
			{
				SetLevel((*nask));
				break;
			}
		}
	gotoMeny->Enable(uID_Neste, levelsize != arkiv->size());
	gotoMeny->Enable(uID_Forrige, levelsize != 1);
	}
}

void Hovedvindu::Do_Forrige(void)
{
	if(levelsize > 1)
	{
		levelsize--;
		Arkiv::iterator nask;
		int intnask = 0;
		
		for(nask = arkiv->begin(); nask != arkiv->end(); nask++)
		{
			intnask++;
			if(intnask == levelsize)
			{
				SetLevel((*nask));
				break;
			}
		}
		
		gotoMeny->Enable(uID_Neste, levelsize != arkiv->size());
		gotoMeny->Enable(uID_Forrige, levelsize != 1);
	}
}

void Hovedvindu::Do_Test(void)
{
}

void Hovedvindu::OnSize(wxSizeEvent &event)
{
	event.Skip();

	if(finalBackBuffer)
	{
		delete finalBackBuffer;
	}

	wxSize size_vindu = editorVindu->GetClientSize();

	finalBackBuffer = new wxBitmap(size_vindu.GetWidth(), size_vindu.GetWidth());

	if(backBuffer)
	{
		strekkBilde();
		flipBackBuffer();
	}

}

void Hovedvindu::OnPaint(wxPaintEvent &event)
{
	wxPaintDC vindu_paint(editorVindu);
	
	if(!backBuffer)
	{
	wxSize size_vindu = editorVindu->GetClientSize();
	wxClientDC vinduDC(editorVindu);

	vinduDC.Clear();

	vinduDC.DrawRectangle(0,0,size_vindu.GetWidth(), size_vindu.GetWidth());
	}
	
	else
	{
	strekkBilde();
	flipBackBuffer();
	}
}

void Hovedvindu::updateDraw(void)
{
	if(!backBuffer)
		return;

	wxMemoryDC backBufferDC;

	backBufferDC.SelectObject(*backBuffer);
	backBufferDC.SetBackground(*wxBLACK_BRUSH);
	backBufferDC.Clear();

	backBufferDC.SetPen(wxColour(128,128,128));

	for(int x = 0; x <= Levelmap->x; x++)
	{
		for(int y = 0; y <= Levelmap->y; y++)
		{
			if(x < Levelmap->x && y < Levelmap->y)
			{
				int img = Levelmap->level[x][y];
				//Levelmap->level[xlol][ylol] = 0;

				if(img >= 0 && img <= 4)
				{
				backBufferDC.DrawBitmap(sprites[0], x * (IKON_STORRELSE + 1) + 1, y * (IKON_STORRELSE + 1));
				backBufferDC.DrawBitmap(sprites[img], x * (IKON_STORRELSE + 1) + 1, y * (IKON_STORRELSE + 1),true);
				}
			}
			// Loddrett
			backBufferDC.DrawLine(wxPoint((IKON_STORRELSE + 1) * (x), 0), wxPoint((IKON_STORRELSE + 1) * (x), Levelmap->y * (IKON_STORRELSE + 1)));
			// Vannrett
			backBufferDC.DrawLine(wxPoint(0, (IKON_STORRELSE + 1) * y) , wxPoint(Levelmap->x * (IKON_STORRELSE + 1) + 1, (IKON_STORRELSE + 1) * y));
			}
	}
/*		for (int b = 0; b < bredde; b++)
	{
		for(int c = 0; c < hoyde; c++)
		{
			Levelmap->level[b][c] = 0;
		}
	}*/
	backBufferDC.SelectObject(wxNullBitmap);

	strekkBilde();
	flipBackBuffer();

}

void Hovedvindu::flipBackBuffer(void)
{
	wxSize gameWindow = editorVindu->GetClientSize();
	wxMemoryDC finalDC;

	wxClientDC output(editorVindu);

	finalDC.SelectObject(*finalBackBuffer);

	output.Blit(wxPoint(0,0), gameWindow, &finalDC, wxPoint(0,0));

	finalDC.SelectObject(wxNullBitmap);
}

void Hovedvindu::strekkBilde(void)
{
	wxSize gameWindow = editorVindu->GetClientSize();

	wxSize strekkStorrelse;
	
	if(gameWindow.GetWidth() * Levelmap->y / Levelmap->x < gameWindow.GetHeight())
	{
		strekkStorrelse.Set(gameWindow.GetWidth(), gameWindow.GetWidth() * Levelmap->y / Levelmap->x);
	}
	else
	{
		strekkStorrelse.Set(gameWindow.GetHeight() * Levelmap->x / Levelmap->y, gameWindow.GetHeight());
	}
	wxImage strekkBilde = backBuffer->ConvertToImage();
	strekkBilde = strekkBilde.Scale(strekkStorrelse.GetWidth(),strekkStorrelse.GetHeight());
	wxMemoryDC finalDC;
	wxMemoryDC bildeDC;

	finalDC.SelectObject(*finalBackBuffer);
	bildeDC.SelectObject(strekkBilde);


	finalDC.SetBackground(*wxWHITE_BRUSH);
	finalDC.Clear();

	wxPoint midt;

	midt.x  = (gameWindow.GetWidth() - strekkStorrelse.GetWidth()) / 2;
	midt.y  = (gameWindow.GetHeight() - strekkStorrelse.GetHeight()) / 2;

	finalDC.Blit(midt, strekkStorrelse, &bildeDC, wxPoint(0,0));
	finalDC.SetBrush(*wxTRANSPARENT_BRUSH);
	finalDC.DrawRectangle(wxPoint(0,0), gameWindow);

	bildeDC.SelectObject(wxNullBitmap);
	finalDC.SelectObject(wxNullBitmap);
	
	posi_x = midt.x;
	posi_y = midt.y;

	mons_x = strekkStorrelse.GetWidth();
	mons_y = strekkStorrelse.GetHeight();
	
}

void Hovedvindu::OnMouse(wxMouseEvent &event)
{
	wxPoint musPos = event.GetPosition();

	if(musPos.x >= posi_x && musPos.y >= posi_y && musPos.x <= posi_x + mons_x && musPos.y <= posi_y + mons_y)
	{	
		int mousePosX = (musPos.x - posi_x) / (mons_x / Levelmap->x);
		int mousePosY = (musPos.y - posi_y) / (mons_y / Levelmap->y);

		if(mousePosX != mus_x || mousePosX != mus_y)
		{
			mus_x = mousePosX;
			mus_y = mousePosY;

			if(event.LeftIsDown())
			{
				OnMousePush(event);
			}
		}
	}
	else
	{
		if(mus_x != -2 && mus_y != -2)
		{
			mus_x = -2;
			mus_y = -2;
			updateDraw();
		}
	}
}

void Hovedvindu::OnMousePush(wxMouseEvent &event)
{
	playercount = 0;
	playercountnd = 0;
	if(mus_x != -2 && mus_y != -2 && selecta != -1)
	{
		if(backBuffer)
		{
			wxMemoryDC backBufferDC;
			backBufferDC.SelectObject(*backBuffer);
			
	//		if(playercount < 3)
	//		{
			for(int x = 0; x < Levelmap->x; x++)
			{
					for(int y = 0; y < Levelmap->y; y++)
					{
						if(Levelmap->level[x][y] == TOOL_SPILLER)
						{
							playercount++;
						}
						else if(Levelmap->level[x][y] == 4)
						{
							playercountnd++;
						}
					}
			}
		//	}
			if(playercount == 1 && selecta == TOOL_SPILLER)
			{	
				selecta = 4;
			}
			//if(playercount >= 2 && selecta == TOOL_SPILLER || playercount >= 2 && selecta == 4)
			if(playercount >= 1 && playercountnd >= 1 && selecta == 4)
			{
				return;
			}

			if(mus_x < Levelmap->x && mus_y < Levelmap->y)
			{
					//backBufferDC.SetBackground(*wxBLACK_BRUSH);
				//backBufferDC.Clear();
				//if(Levelmap->level[mus_x][mus_y] == TOOL_SPILLER && selecta == TOOL_VISK)
				//{
				//	playercount--;
				//}

				
				//backBufferDC.DrawBitmap(sprites[0], mus_x * (IKON_STORRELSE + 1) + 1, mus_y * (IKON_STORRELSE + 1) + 1);
				backBufferDC.DrawBitmap(sprites[selecta], mus_x * (IKON_STORRELSE + 1) + 1, mus_y * (IKON_STORRELSE + 1) + 1, true);
				Levelmap->level[mus_x][mus_y] = selecta;
			}
			

			backBufferDC.SelectObject(wxNullBitmap);

			//updateDraw();
			strekkBilde();
			flipBackBuffer();
		}
	}

}

void Hovedvindu::Lagrefil(wxString filnavn)
{
	FILE *fil;
	fopen_s(&fil,filnavn,"w+b");

	int antall = (int)arkiv->size();

	fwrite(&antall, sizeof(int), 1, fil);

	Arkiv::iterator iterator;

	for(iterator = arkiv->begin(); iterator != arkiv->end(); iterator++)
	{
		map *Maplevel = (*iterator);

		fwrite(&Maplevel->x, sizeof(int), 1, fil);
		fwrite(&Maplevel->y, sizeof(int), 1, fil);

		for(int i = 0; i < Maplevel->x; i++)
		{
			fwrite(Maplevel->level[i],sizeof(char),Maplevel->y,fil);
		}
		
	}
	fclose(fil);
}

/*
void Hovedvindu::OnConnectToServer(wxCommandEvent&WXUNUSED(event))
{
wxIPV4address addr;
addr.Hostname(wxT("localhost "));
addr.Service(3000);
//Create the socket
wxSocketClient*Socket =new wxSocketClient();
//Set up the event handler and subscribe to most events
Socket->SetEventHandler(*this,SOCKET_ID);
Socket->SetNotify(wxSOCKET_CONNECTION_FLAG |
wxSOCKET_INPUT_FLAG |
wxSOCKET_LOST_FLAG);
Socket->Notify(true);
//Wait for the connection event
Socket->Connect(addr,false);
}

void Hovedvindu::OnSocketEvent(wxSocketEvent&event)
{
//The socket that had the event
wxSocketBase*sock =event.GetSocket();
//Common buffer shared by the events
char buf [10 ];
switch(event.GetSocketEvent())
{
case wxSOCKET_CONNECTION:
{
	//Fill the arry with the numbers 0 through 9
//as characters
char mychar ='0';
for (int i =0;i <10;i++)
{
	buf [i]=mychar++;
}
//Send the characters to the server
sock->Write(buf,sizeof(buf));
break;
}
case wxSOCKET_INPUT:
{
sock->Read(buf,sizeof(buf));
break;
}
//The server hangs up after sending the data
case wxSOCKET_LOST:
{
sock->Destroy();
break;
}
}
}*/